.PS
# `ShowcaseExample.m4'
# https://tex.stackexchange.com/questions/758824/showcase-of-beautiful-electrical-circuit-diagrams-done-in-tex-friends
# https://www.mdpi.com/2079-9292/10/21/2631

log_init
define(`sub',`_{\hbox{\scriptsize `$1'}}')
pushdef(`lg_plen',0)

  del = 4*L_unit
TopRow: [
  setdir_(R)
 M1: Mux(5,\normalsize AD8429,X,dimen_*4*3/5,dimen_*4)
  "$+$" at M1.In0 ljust; "$-$" at M1.In4 ljust;
  line from M1.In1 left_ del
  resistor(down_ M1.In1.y-M1.In3.y)
  rlabel(,\shortstack[r]{$R_{\hbox{\scriptsize G}}$\\\SI{131}{\ohm}})
  line to M1.In3
  dot(at M1.Out+(del*3/2,0))
  {line from M1.Out to 2 between M1.Out and Here
   dot(,,1); "$V`'sub(out)$" at last [].e ljust}
  line up_ del; tbox(r_text(90,$V`'sub(out)$))
 Vref: "$V`'sub(ref)$" above rjust at 2/3 between M1.SW and M1.SE;
  right_
 OA3: opamp(,,,dimen_*5/4) with .w at (M1.w.x,M1.SW.y-2.25*del)
  "OA3" at OA3.C
  line from OA3.Out to (Vref,OA3) then to Vref
  line from OA3.In1 left_ del then up del*9/8; continue to (Vref,Here); dot
  arrow from OA3.In2 left_ del then down_ del*3/2
 Rz: resistor(right_ dimen_ at Here)
  rlabel(,\shortstack{$R`'sub(z)$\\\SI{10}{\kilo\ohm}})
  {resistor(right_ dimen_*3/4 from Rz.end)
   arrow right_ del; "\SI{5}{\volt}" ljust}
  {resistor(left_ dimen_*3/4 from Rz.start)
   arrow left_ del; "\SI{-5}{\volt}" rjust}

define(`rstring',`[
  ground(,T)
 Vin: source(up_ (M1.In0.y-M1.In4.y)/2,V)
  llabel(,V^`'ifelse(`$1',1,+,-)sub(in)); {move left_ 17bp__ from last [].w}
  resistor(right_ elen_); llabel(,\SI{10}{\kilo\ohm}); dot
  { resistor(down_ Vin.len); rlabel(,\SI{100}{\ohm}); ground(,T) }
 Rp: resistor(right_ elen_); rlabel(,R^ifelse(`$1',1,+,-))
  llabel(,\shortstack{\SI{0}{\ohm}\\\SI{5}{\kilo\ohm}\\\SI{50}{\kilo\ohm}})
  {dot; resistor(down_ Vin.len/2)
   llabel(,\shortstack[l]{$R`'sub(A`$1')$\\\SI{5}{\kilo\ohm}})
   switch(down_ Vin.len/2,O)
   llabel(,\shortstack[l]{\small
    v`'ifelse(`$1',1,`+\scriptsize R\\3',`-\scriptsize R\\2')})
   G1: ground(,T)}
  line right_ dimen_; dot
  {line down_ Vin.len/2
   switch(down_ Vin.len/2,O)
   llabel(,\shortstack[l]{\small
    v`'ifelse(`$1',1,`+\scriptsize GND\\4',`-\scriptsize GND\\1')})
   G2: ground(,T)}
  line right_ dimen_*2/3
 C`$1'B: dot; {"C`$1'B" at last [].nw rjust above}
  capacitor(right_ elen_); llabel(,\SI{10}{\micro\farad})
  rlabel(,C`'sub(B`$1'))
 C`$1'A: dot; {"C`$1'A" at last [].ne ljust above}
  ifelse(`$1',1,`{line dashed 0.04 up_ dimen_*0.8 then left_ elen_ then to C1B
    circle fill_(1) dashed 0.04 rad sourcerad_ at C1B+(elen_/2,dimen_*0.8)
    arrow dashed 0.04 left_ sourcerad_*3/2 at last circle
    "$i`'sub(f`$1')$" at last circle.n above}',
   `{line dashed 0.04 down_ dimen_*0.8 then left_ elen_ then to C2B
    circle fill_(1) dashed 0.04 rad sourcerad_ at C2B+(elen_/2,-dimen_*0.8)
    arrow dashed 0.04 left_ sourcerad_*3/2 at last circle
    "$i`'sub(f`$1')$" at last circle.s below}')
 {ifelse(`$1',1,`resistor(from C1A down_ (M1.In0.y-M1.In4.y)/2)
    llabel(,\shortstack[l]{$R`'sub(B1)$\\\SI{160}{\kilo\ohm}})
    dot; line left del; ground',
   `resistor(from C2A up_ (M1.In0.y-M1.In4.y)/2)
    rlabel(,\shortstack[l]{$R`'sub(B2)$\\\SI{160}{\kilo\ohm}})')}
  line right_ del; resistor(right elen_); llabel(,\SI{100}{\ohm})
 D: dot
 R33: resistor right_(elen_); llabel(,\SI{33}{\ohm})
 ]')

 S1: rstring(1) with .R33.end at M1.In0
 S2: rstring(2) with .R33.end at M1.In4
  capacitor(down_ from S1.D to S2.D)
  rlabel(,\shortstack{$C`'sub(hf)$\\\SI{1}{\nano\farad}})
  "Switches:" at 1/2 <S2.G1,S2.G2>+(0,-del*7/4) below "1$\times$ADG202AKN"
  ]

SecondRow: [
 ADN: [
 C: circle rad sourcerad_; line from C.sw to C.ne; line from C.nw to C.se
      line right_ C.rad*2 from C.e
 MR: Mux(,,X,sourcerad_*2,sourcerad_*6)
  line left_ C.rad up_ C.rad*3/4 from C+(Rect_(C.rad,150)) \
    then up_ C.rad*3/4; down_
 MT: Mux(,,X,sourcerad_*2,sourcerad_*6,,X1:8/7 between In0 and In1;\
      X0: 8/7 between In1 and In0) with .Out at Here
  "\small $-$" at MT.X0 below; "+" at MT.X1 below
  line left_ C.rad down_ C.rad*3/4 from C+(Rect_(C.rad,210)) \
    then down_ C.rad*3/4; up_
 MB: Mux(,,X,sourcerad_*2,sourcerad_*6,,X1:8/7 between In0 and In1;\
      X0:8/7 between In1 and In0) with .Out at Here
  "\small $-$" at MB.X1 above; "+" at MB.X0 above
  dx = MB.X1.x-MB.X0.x
 Bx: [ B: box wid dx*4 ht dx*3 at C+(dx/2,0)
   for i=1 to 4 do {
     exec sprintf("Pin%g: (i-1/2)/4 <B.sw,B.se>; \"%g\" at Pin%g above rjust;
       Pin%g: (i-1/2)/4 <B.ne,B.nw>; \"%g\" at Pin%g below rjust;",i,i,i,\
       4+i,4+i,4+i) } ] with .Pin8 at MT.X1+(0,dx/2)
  line from MR.Out to (Bx.Pin5,MR.Out) then to Bx.Pin5
 Vr: 1/2 between MR.SW and MR.SE
  line from Vr down_ sourcerad_; continue to (Bx.Pin4,Here) then to Bx.Pin4
  ]
  "ADN835ANZ" at ADN.w rjust
  hdn = ADN.ht/(dimen_); dx = ADN.MB.X1.x-ADN.MB.X0.x
  line from ADN.MT.X1 up del+ADN.n.y-ADN.MT.n.y then left del/2
  resistor(left_ dimen_); rlabel(,\SI{100}{\ohm}); right_
 OA4: opamp(,,,dimen_*5/4) with .Out at Here; "OA4" at OA4.C
  line from OA4.In1 left_ del then up del*3/2
  continue to (OA4.Out,Here) then to OA4.Out; dot
  line left_ del from OA4.In2; dot
  {capacitor(down_ elen_); rlabel(,C`'sub(LP)); llabel(,\SI{1}{\micro\farad})
   ground(,T)}
  resistor(left_ dimen_); rlabel(,R`'sub(LP)); llabel(,\SI{10}{\kilo\ohm})
  tbox(V`'sub(ctrl),,,<); right_
 OA1: opamp(,,,dimen_*5/4) with .Out at (OA4.Out.x,ADN.s.y-(OA4.Out.y-ADN.n.y));
  "OA1" at OA1.C
  resistor(right_ dimen_ from OA1.Out); rlabel(,\SI{100}{\ohm})
  line to (ADN.Bx.Pin1,Here) then to ADN.MB.X0
  line from OA1.In1 left_ del then up_ del*3/2; dot
  {resistor(right_ to (OA1.Out,Here))
   llabel(,R`'sub(g2)); rlabel(,\SI{2}{\kilo\ohm})
   line to OA1.Out; dot}
  resistor(left_ dimen_); rlabel(,R`'sub(g1)); llabel(,\SI{1}{\kilo\ohm})
  tbox(V`'sub(out),,,<)
  line from OA1.In2 left_ del then down_ del; ground
  dot(at (ADN.Bx.Pin6,OA4)); {"\SI{3.3}{\micro\farad}" at last [].e ljust}
 Cp: capacitor(left_ dx,C+); dot
  dot(at Here+(0,del*3/2)); capacitor(right_ dx); dot
  {"\SI{10}{\nano\farad}" at last [].e ljust}
  arrow from ADN.Bx.Pin6 to Here chop 0 chop -del; {"\SI{5}{\volt}" above}
  line from ADN.MT.X0 up_ Here.y-ADN.MT.X0.y-del/2 \
    then left_ del then down_ del/2
  ground(,T)
  dot(at (ADN.Bx.Pin2.x,ADN.s.y-(Cp.y-ADN.n.y)))
  capacitor(right_ dx,C+); dot; {"\SI{3.3}{\micro\farad}" at last [].e ljust}
  dot(at Here-(0,del*3/2)); {"\SI{10}{\nano\farad}" at last [].e ljust}
  {arrow from ADN.Bx.Pin3 to Here chop 0 chop -del; "\SI{-5}{\volt}" below}
  capacitor(left_ dx); dot
  line from ADN.MB.X1 up_ Here.y-ADN.MB.X0.y-del/2; ground
 T: dot(at ADN.ne+(del,del))
  {resistor(down_ to ADN.se+(del,-del)); llabel(,\SI{2}{\kilo\ohm})
 Dp: dot
   {line to (ADN.Bx.Pin4,Here) then to ADN.Bx.Pin4}
   resistor(down_ dimen_); rlabel(,\SI{100}{\ohm})
 G: ground(,T) }
  line from Here+(del*3,0) to (ADN.Bx.Pin5,Here) then to ADN.Bx.Pin5; right_
 OA2: opamp(,,,dimen_*5/4,R) with .In1 at last line.start; "OA2" at OA2.C

define(`VO1263A',`[ dh = dimen_*2/3
 B1: VO1263DL
 B2: VO1263DL with .D.start at B1.D.end-(0,dh*2/3)
 Bx: box ht B1.D.start.y-B2.D.end.y+del wid B1.L.x-B1.D.x+del \
    at 1/2 between B1.D.start and B2.L.end
  line from B1.D.end left_ del; continue to (Here,B2.D.start) then to B2.D.start
  ]')
define(`VO1263DL',`[
 D: diode(down_ dh,LE)
 L: line invis from D.start+(dimen_*3/4,0) down_ dh
  pushdef(`dimen_',dimen_*2/3)
  line from L.start down_ L.len/4; diode(down_ dimen_/8 at Here)
  line dashed dimen_/20 down_ to 3/4 between L.start and L.end
  diode(down_ dimen_/8 at Here); line to L.end popdef(`dimen_')
  ]')

  line from OA2.Out right_ del*3/2
  VO1: VO1263A with .B1.D.start at Here
  VO2: VO1263A with .n at VO1.s+(0,-del/2)
  "VO1263$\times$2" at VO1.Bx.n above
 S: dot(at (OA2.In2.x-del,(1/2 between VO1.s and VO2.n).y))
  line from OA2.In2 to (S,OA2.In2) then to S
  resistor(down_ to (Here,G))
    llabel(,\shortstack[l]{$R`'sub(L)$\\\SI{100}{\ohm}})
  ground(,T)

  line from VO1.B2.D.end left_ del then down_ VO1.B2.D.end.y-VO2.B1.D.start.y \
    then to VO2.B1.D.start
  line from S to (VO1.B2.D.end.x-del,S.y); dot
  dot(at OA2.Out); line to (Here,VO2.B2.D.end) then to VO2.B2.D.end 

  dot(at VO1.B1.L.end+(del,0))
  { line to (Here,VO2.B1.L.start) then to VO2.B1.L.start }
  line right_ from VO1.B1.L.end to Here+(dimen_,0)
 Rt: Here
  tbox("C1A")
  dot(at VO1.B1.L.start+(del*3/2,0))
  { line to (Here,VO2.B1.L.end) then to VO2.B1.L.end }
  line right_ from VO1.B1.L.start to (Rt,Here)
  tbox("C1B")
  {arrow <- from (Rt.x-del/6,Here.y) left_ dimen_/8
  "$i`'sub(f1)$" at Here+(0,lthick*2) above}
  dot(at VO1.B2.L.end+(del*2,0))
  { line to (Here,VO2.B2.L.start) then to VO2.B2.L.start }
  line right_ from VO1.B2.L.end to (Rt,Here)
  tbox("C2B")
  dot(at VO1.B2.L.start+(del*5/2,0))
  { line to (Here,VO2.B2.L.end) then to VO2.B2.L.end }
  line right_ from VO1.B2.L.start to (Rt,Here)
  tbox("C2A")
  arrow <- from (Rt.x-del/6,Here.y) left_ dimen_/8
  "$i`'sub(f2)$" at Here+(0,lthick*2) above
   
  ] with .nw at TopRow.sw+(0,-dimen_/2)
  popdef(`lg_plen')

.PE
